/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterBlockWithBeginNode;
import com.aptana.formatter.nodes.FormatterTextNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import com.aptana.js.core.parsing.ast.JSArgumentsNode;
import com.aptana.js.core.parsing.ast.JSBinaryOperatorNode;
import com.aptana.js.core.parsing.ast.JSVarNode;
import com.aptana.parsing.ast.IParseNode;

public class FormatterJSDeclarationNode
extends FormatterBlockWithBeginNode {
    protected boolean hasBlockedChild;
    protected IParseNode node;
    protected boolean hasCommentBefore;

    public FormatterJSDeclarationNode(IFormatterDocument document, boolean hasBlockedChild, IParseNode node, boolean hasCommentBefore) {
        super(document);
        this.hasBlockedChild = hasBlockedChild;
        this.node = node;
        this.hasCommentBefore = hasCommentBefore;
    }

    public void setBegin(IFormatterTextNode begin) {
        if (this.node.getNodeType() == 63 && this.isMultipleVarDeclaration() && this.getDocument().getBoolean("js.formatter.newline.between.var.declarations")) {
            FormatterTextNode newBegin = new FormatterTextNode(begin.getDocument(), begin.getStartOffset(), begin.getEndOffset()){

                public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
                    visitor.ensureLineStarted(context);
                    visitor.writeText(context, "    ", false);
                    super.accept(context, visitor);
                }
            };
            begin = newBegin;
        }
        super.setBegin(begin);
    }

    protected boolean isAddingBeginNewLine() {
        if (this.hasCommentBefore) {
            return true;
        }
        if (this.node instanceof JSBinaryOperatorNode) {
            return false;
        }
        switch (this.node.getNodeType()) {
            case 76: {
                return this.node.getParent().getChild(0) == this.node || this.getDocument().getBoolean("js.formatter.newline.before.name.value.pairs");
            }
            case 63: {
                return this.isMultipleVarDeclaration() && this.getDocument().getBoolean("js.formatter.newline.between.var.declarations");
            }
        }
        if (FormatterJSDeclarationNode.isPartOfExpression(this.node)) {
            return false;
        }
        switch (this.node.getNodeType()) {
            case 66: {
                return this.getDocument().getBoolean("js.formatter.newline.before.catch");
            }
            case 67: {
                return !this.hasBlockedChild || this.getDocument().getBoolean("js.formatter.newline.before.finally");
            }
            case 64: 
            case 70: {
                return !this.isLoopOrExpressionNode(this.node.getParent());
            }
        }
        return true;
    }

    protected boolean isMultipleVarDeclaration() {
        return this.node.getParent() instanceof JSVarNode && this.node.getParent().getChild(0) != this.node;
    }

    public static boolean isPartOfExpression(IParseNode node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 1: 
            case 48: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 68: 
            case 75: 
            case 76: 
            case 85: {
                return true;
            }
        }
        return false;
    }

    public int getSpacesCountBefore() {
        JSArgumentsNode argumentsNode;
        short parentNodeType = this.node.getParent().getNodeType();
        if (parentNodeType == 58) {
            return 0;
        }
        if (parentNodeType == 61 && (argumentsNode = (JSArgumentsNode)this.node.getParent()).getChild(0) == this.node) {
            return 0;
        }
        short nodeType = this.node.getNodeType();
        if (nodeType == 64 && this.isLoopOrExpressionNode(this.node.getParent())) {
            return 0;
        }
        return 1;
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        return !this.isAddingBeginNewLine();
    }

    protected boolean isIndenting() {
        return !this.hasBlockedChild;
    }

    private boolean isLoopOrExpressionNode(IParseNode iParseNode) {
        switch (iParseNode.getNodeType()) {
            case 80: 
            case 88: 
            case 89: {
                return true;
            }
        }
        return FormatterJSDeclarationNode.isPartOfExpression(iParseNode);
    }
}

